<?php

namespace Inside\ECEN\Providers;

use Illuminate\Support\Facades\Event;
use Inside\Application;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\ECEN\Listeners\ContentCreatedListener;
use Inside\ECEN\Http\Middlewares\GedMiddleware;
use Inside\ECEN\Listeners\ContentUpdatedListener;
use Inside\ECEN\Listeners\UsersCreatedListener;
use Inside\Providers\ServiceProvider as BaseServiceProvider;

/**
 * ECEN Service provider.
 *
 * @category Class
 * @package  Inside\ECEN\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * @var Application
     */
    protected $app;

    /**
     * @var array
     */
    protected $listen = [
        ContentFullyInsertedEvent::class => [
            ContentCreatedListener::class,
            UsersCreatedListener::class,
        ],
        ContentFullyUpdatedEvent::class => [
            ContentUpdatedListener::class,
        ],
    ];

    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        foreach ($this->listen as $event => $listeners) {
            foreach ($listeners as $listener) {
                Event::listen($event, $listener);
            }
        }
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/permission.php', 'permission');

        $this->app->middleware([
            GedMiddleware::class
        ]);

        $this->mergeConfigTo(__DIR__ . '/../../config/archive.php', 'archive');
        $this->mergeConfigTo(__DIR__ . '/../../config/notify.php', 'notify');

        $this->app->register(\Barryvdh\DomPDF\ServiceProvider::class);

        $this->app->alias('PDF', \Barryvdh\DomPDF\Facade::class);
    }
}
