<?php

namespace Inside\ECEN\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Host\Bridge\BridgeContent;

class UsersCreatedListener implements ShouldQueue
{
    public function handle(ContentFullyInsertedEvent $event): void
    {
        $model = $event->model;
        if ($model->content_type !== 'users' || $model->is_client === false || $model->clients[0]->image === null) {
            return;
        }

        $data = [
            'type' => 'node',
            'uuid' => $model->uuid,
            'image' => $model->clients[0]->image
        ];

        $bridge = new BridgeContent();
        $bridge->contentUpdate(class_to_type($model), $data);
    }
}
