<?php

namespace Inside\ECEN\Listeners;

use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class NotificationGedListener extends BaseNotificationListener
{
    /**
     * @param mixed $model
     * @param string $method
     * @param bool $uniqueMail
     */
    public function notification($model, string $method, bool $uniqueMail = false): void
    {
        /** @var Collection<NotificationType> $types */
        $types = NotificationType::where('model', get_class($model))->where(
            function ($query) use ($method) {
                $query->where('action', $method);
            }
        )->get();

        $siteUuids = $model->sites->pluck('uuid_host')->toArray();
        $clientsUuids = $model->clients->pluck('uuid_host')->toArray();
        $client = null;
        $roles = '';

        if (class_to_type($model) === 'shared_documents') {
            $roles = 'is_client';
        } elseif (class_to_type($model) === 'space_documents') {
            $roles = 'is_key_account_manager';
            $client = $model->clients->pluck('title')->toArray();
            if ($model->langcode === 'fr') {
                $client = 'par '.$client[0];
            } else {
                $client = 'by '.$client[0];
            }
        }

        $subscribers = User::whereHas('information.clients', function ($query) use ($clientsUuids) {
            $query->whereIn('inside_content_clients.uuid_host', $clientsUuids);
        })->whereHas('information.sites', function ($query) use ($siteUuids) {
            $query->whereIn('inside_content_sites.uuid_host', $siteUuids);
        })->whereHas('information', function ($query) use ($roles) {
            $query->where('inside_content_users.'.$roles, 1);
        })->get();

        if ($roles === 'is_key_account_manager') {
            $generic = Users::where('email', 'mypartner.cenexi@cenexi.com')->first();
            $subscribers->push($generic);
        }

        foreach ($types as $type) {
            $subscribers->each(
                function ($subscriber) use ($type, $model, $uniqueMail, $client) {
                    if ($uniqueMail && $type->via === 'email' && $subscriber->langcode !== $model->langcode) {
                        return;
                    }
                    $this->when = $this->getInterval($type, $model);
                    $this->route = $subscriber;
                    $this->notify(
                        $type,
                        $subscriber,
                        $model,
                        [
                            'from' => $model->author,
                            'client_title' => $client,
                            'client' => [
                                'uuid' => $model->clients->pluck('uuid')->first(),
                                'machine_name' => $model->clients->pluck('machine_name')->first(),
                            ],
                            'site' => [
                                'uuid' => $model->sites->pluck('uuid')->first(),
                                'name' => $model->sites->pluck('title')->first(),
                            ]
                        ]
                    );
                }
            );
        }
    }
}
