<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Str;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Clients;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddMachineNameFieldToClients extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (Schema::hasModel('florians')) {
            $this->bridge->contentTypeDelete('florians');
        }

        $this->bridge->contentTypeCreateOrUpdateField('clients', 'machine_name', [
            'name' => 'machine_name',
            'searchable' => false,
            'required' => false,
            'weight' => 0,
            'type' => BridgeContentType::TEXT_FIELD,
            'title' => [
                'en' => 'Machine name',
                'fr' => 'Nom machine'
            ],
            'widget' => [
                'hidden' => true,
            ],
            'settings' => [
            ],
        ]);

        $clients = Clients::query()->where('langcode', 'en')->get();

        $bridge = new BridgeContent();

        foreach ($clients as $client) {
            $bridge->contentUpdate('clients', [
                'type' => 'node',
                'bundle' => 'clients',
                'uuid_host' => $client->uuid_host,
                'machine_name' => Str::slug(trim($client->title))
            ]);
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
