<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class RemakeContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $contentTypesToRemove = ['key_account_managers', 'client_contacts', 'customers', 'dashboards', 'dashboard_kpi', 'dashboard_stats', 'notes'];

        foreach ($contentTypesToRemove as $contentType) {
            if (Schema::hasModel($contentType)) {
                $this->bridge->contentTypeDelete($contentType);
            }
        }

        $this->migrateContent('clients');
        $this->migrateContent('key_account_managers');
        $this->migrateContent('cenexi_notes');
        $this->migrateContent('dashboards');

        $fieldsToRemove = ['shortcuts_menus', 'customers', 'post'];

        foreach ($fieldsToRemove as $field) {
            $this->bridge->contentTypeDeleteField('user', 'user', $field);
        }

        $fields = [
            [
                'name' => 'is_key_account_manager',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'default' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Key Account Manager',
                    'en' => 'Key Account Manager',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 11,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'is_client',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'default' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Contact client',
                    'en' => 'Client contact',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 11,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'sites',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Site Cenexi',
                    'en' => 'Cenexi Site',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['sites'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'clients',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Client',
                    'en' => 'Client',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['clients'],
                    'cardinality' => 1,
                ],
                'selectable_all' => true,
            ],
        ];

        foreach ($fields as $field) {
            $this->bridge->contentTypeCreateOrUpdateField('users', $field['name'], $field);
        }

        $this->bridge->contentTypeDeleteField('node', 'sites', 'customers');

        $contentTypes = ['shared_documents', 'space_documents', 'clients'];

        foreach ($contentTypes as $contentType) {
            $this->bridge->contentTypeCreateOrUpdateField($contentType, 'sites', [
                'name' => 'sites',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Site Cenexi',
                    'en' => 'Cenexi site',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['sites'],
                    'cardinality' => -1,
                ],
            ]);

            if ($contentType === 'clients') {
                continue;
            }

            $this->bridge->contentTypeCreateOrUpdateField($contentType, 'clients', [
                'name' => 'sites',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Client',
                    'en' => 'Client',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['sites'],
                    'cardinality' => -1,
                ],
            ]);
        }
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
