<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddSitesField extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $contentTypes = ['shared_documents', 'space_documents', 'dashboard_stats'];

        foreach ($contentTypes as $contentType) {
            $this->bridge->contentTypeCreateOrUpdateField($contentType, 'sites', [
                'name' => 'sites',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Sites',
                    'en' => 'Sites',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['sites'],
                    'cardinality' => -1,
                ],
            ]);
        }
        $this->finishUp();
    }


    public function down(): void
    {
    }
}
