<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => true,
        'global_searchable' => true,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'listing_type'      => 'content',
        'name'              => 'shared_folders',
        'title'             => [
            'en' => 'My shared folders',
            'fr' => 'Mes dossiers partagés'
        ],
    ],
    'fields'  => [
        [
            'name' => 'color',
            'searchable' => false,
            'required' => false,
            'weight' => $weight,
            'type' => BridgeContentType::TEXT_FIELD,
            'title' => [
                'en' => 'Color',
                'fr' => 'Couleur'
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'settings' => [
            ],
        ],
        [
            'name' => 'shared_folders',
            'searchable' => false,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'en' => 'Parent file',
                'fr' => 'Dossier parent'
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'shared_folders',
                'cardinality' => -1,
            ],
        ],
    ],
];
