<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'key_account_managers',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'title' => [
            'en' => 'Key Account Manager',
            'fr' => 'Key Account Manager',
        ],
    ],
    'fields' => [
        [
            'name' => 'users',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'en' => 'User',
                'fr' => 'Utilisateur',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'sites',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'en' => 'Cenexi site',
                'fr' => 'Site Cenexi',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['sites'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'clients',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'en' => 'Client',
                'fr' => 'Client',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['clients'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
    ],
];
