<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Clients;
use Inside\Content\Models\Contents\SharedFolders;
use Inside\Content\Models\Contents\Sites;
use Inside\Content\Models\Contents\SpaceFolders;
use Inside\Content\Models\Contents\Users;

return [
    'locked' => [],
    'global_scope' => function ($builder, $user, $model) {
        $contentTypes = ['shared_documents', 'space_documents', 'dashboards', 'cenexi_notes'];

        if (!in_array($model->content_type, $contentTypes)) {
            return;
        }

        $userContent = Users::query()->find($user->uuid);

        if ($userContent->is_key_account_manager) {
            return;
        }

        $references = ['sites', 'clients'];

        $userReferences = [];

        /** @var Request $request */
        $request = request();

        foreach ($references as $reference) {
            if ($reference === 'sites' && $request->has('currentSite')) {
                $site = Sites::query()->find($request->get('currentSite'));
                $userReferences['sites'] = [$site->uuid_host];
                continue;
            }

            if ($reference === 'clients' && $request->has('currentClient')) {
                $client = Clients::query()->find($request->get('currentClient'));
                $userReferences['clients'] = [$client->uuid_host];
                continue;
            }

            $userReferences[$reference] = $userContent->{\Illuminate\Support\Str::camel($reference)}->count() ? $userContent->{\Illuminate\Support\Str::camel($reference)}->pluck('uuid_host')->toArray() : [];
        }

        $builder->where(function ($subquery) use ($model, $user, $userReferences) {
            $subquery->orWhereIn($model->getTable().'.uuid', function ($where) use ($model, $user) {
                $where->select('uuid')
                    ->from($model->getTable())
                    ->where('author', $user->uuid);
            })->orWhereIn($model->getTable().'.uuid', function ($where) use ($model, $userReferences) {
                $where->select('uuid')
                    ->from($model->getTable());

                foreach ($userReferences as $field => $uuids) {
                    $alias = 'pivots'.studly_case($field);
                    $uuids = call_user_func(type_to_class($field).'::query')->whereIn('uuid_host', $uuids)->pluck('uuid')->toArray();

                    $where->join('inside_pivots AS '.$alias, function ($join) use ($alias, $uuids, $model) {
                        $join->on($alias.'.parent_uuid', '=', $model->getTable().'.uuid')
                            ->where(function ($query) use ($alias, $uuids) {
                                $query->whereIn($alias.'.related_uuid', $uuids);
                            });
                    });
                }
            })->groupBy($model->getTable().'.uuid');
        });
    },
    'custom_permissions' => [
        function ($action, $type, $uuid) {
            /** @var User $currentUser */
            $currentUser = Auth::user();
            $user = Users::query()->find($currentUser->uuid);

            switch ($type) {
                case 'space_folders':
                    if (!empty($uuid) && $user->is_client) {
                        return true;
                    }
                    break;
                case 'shared_folders':
                    if (!empty($uuid) && $user->is_key_account_manager) {
                        return true;
                    }
                    break;
                case 'sites':
                case 'clients':
                    if (!$user->is_client && !$user->is_key_account_manager) {
                        return false;
                    }

                    $userReferences = $user->{$type}->pluck('uuid')->toArray();

                    return in_array($uuid, $userReferences);
            }

            return false;
        },
    ],
];
