<?php

namespace Inside\ECEN\Services;

use Dompdf\Dompdf;
use Dompdf\Options;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\View;

/**
 * PDF service.
 *
 * @category Class
 * @package  Inside\ECEN\Services\PdfService
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class PdfService
{
    public function createPdf(string $view, string $filename, ?array $data = null, bool $update = false): void
    {
        if (!$update && Storage::disk('protected')->exists($filename)) {
            return;
        }

        $view = View::make($view, $data ?? []);
        $html = $view->render();
        $html = preg_replace('/>\s+</', '><', $html) ?? '';
        $options = new Options();
        $options->setChroot(cms_base_path());
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->render();
        Storage::disk('protected')->put($filename, $dompdf->output() ?? '');
        $dompdf = null;
        unset($dompdf);
    }
}
