<?php

namespace Inside\ECEN\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyUpdatedEvent;

class ContentUpdatedListener extends NotificationGedListener implements ShouldQueue
{
    public function handle(ContentFullyUpdatedEvent $event): void
    {
        $model = $event->model;

        if (in_array(class_to_type($model), ['shared_documents', 'space_documents'])) {
            $this->notification($model, 'updateDocuments');
        }
    }
}
