<?php

namespace Inside\ECEN\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\ECEN\Services\PdfService;

/**
 * Inside content export controller.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ExportController
{
    /**
     * @var PdfService
     */
    protected $pdfService;

    public function __construct()
    {
        $this->pdfService = new PdfService();
    }

    public function image(Request $request): array
    {
        $image = $request->get('image');

        /** @var User $currentUser */
        $currentUser = Auth::user();
        $filename = 'download/dashboard-' . $currentUser->uuid . '.pdf';

        [, $base64] = explode(';', $image);
        [, $base64] = explode(',', $base64);

        /** @var array $size */
        $size = getimagesizefromstring(base64_decode($base64));

        $this->pdfService->createPdf('dashboard', $filename, [
            'width' => ($size[0]  + 40). 'px',
            'height' => ($size[1] + 40) . 'px',
            'image' => $image,
        ], true);

        return [
            'path' => Storage::disk('protected')->url($filename) . '?' . time(),
        ];
    }
}
