<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'listing_type' => 'content',
        'permissible' => true,
        'categorizable' => false,
        'name' => 'pages',
        'title' => [
            'en' => 'Single page',
            'fr' => 'Page simple'
        ],
    ],
    'fields' => [
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'en' => 'Content',
                'fr' => 'Contenu'
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraph',
                    'title_plural' => 'Paragraphs',
                    'edit_mode' => 'closed',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '_none',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'call_to_action',
                    'file',
                    'files',
                    'html',
                    'image',
                    'map',
                    'slide',
                    'slider',
                    'text',
                    'text_with_image',
                    'tweet',
                    'video',
                    'button',
                    'document_cards',
                    'user_cards'
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
