<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 0;

$blocks = [
    'Manufactured batches',
    'API stock on site',
    'Open invoices',
    'Released batches',
    'Release leadtimes',
    'Key facts',
    'Open deviations',
    'Open complaints',
    'Forecast accuracy',
    'Manufactured YTD',
    'Manufactured YTG'
];
$i = 1;


$contentType = [
    'options' => [
        'name' => 'dashboards',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'title' => [
            'en' => 'Dashboard',
            'fr' => 'Dashboard',
        ],
    ],
    'groups' => [],
    'fields' => [],
];

foreach ($blocks as $block) {
    $contentType['groups'][] = [
        'group_name' => 'group_block_' . $i,
        'entity_type' => 'node',
        'bundle' => 'dashboards',
        'children' => [
            'block_' . $i . '_title',
            'block_' . $i . '_kpi',
            'block_' . $i . '_text',
            'block_' . $i . '_content',
        ],
        'weight' => $weight,
        'parent_name' => '',
        'format_settings' => [
            'label' => $block,
            'description' => '',
            'required_fields' => true,
            'id' => '',
            'classes' => '',
        ],
        'label' => $block,
        'format_type' => 'fieldset',
    ];

    $contentType['fields'][] = [
        'name' => 'block_' . $i . '_title',
        'searchable' => false,
        'translatable' => true,
        'search_result_field' => false,
        'required' => true,
        'default' => $block,
        'weight' => $weight,
        'title' => [
            'en' => 'Title',
            'fr' => 'Titre',
        ],
        'widget' => [
            'type' => BridgeContentType::STRING_WIDGET,
            'settings' => [
                'size' => 60,
                'placeholder' => '',
            ],
            'weight' => $weight++,
            'group' => 'group_block_' . $i
        ],
        'type' => BridgeContentType::TEXT_FIELD,
        'settings' => [
            'max_length' => 255,
            'is_ascii' => false,
            'case_sensitive' => false,
            'cardinality' => 1,
        ],
    ];

    $contentType['fields'][] = [
        'name' => 'block_' . $i . '_kpi',
        'searchable' => false,
        'translatable' => true,
        'search_result_field' => false,
        'required' => false,
        'weight' => $weight,
        'title' => [
            'en' => 'KPI',
            'fr' => 'Chiffre',
        ],
        'widget' => [
            'type' => BridgeContentType::STRING_WIDGET,
            'settings' => [
                'size' => 60,
                'placeholder' => '',
            ],
            'weight' => $weight++,
            'group' => 'group_block_' . $i
        ],
        'type' => BridgeContentType::TEXT_FIELD,
        'settings' => [
            'max_length' => 255,
            'is_ascii' => false,
            'case_sensitive' => false,
            'cardinality' => 1,
        ],
    ];

    $contentType['fields'][] = [
        'name' => 'block_' . $i . '_text',
        'searchable' => false,
        'translatable' => true,
        'search_result_field' => false,
        'required' => false,
        'weight' => $weight,
        'title' => [
            'en' => 'Headline',
            'fr' => 'Chapo',
        ],
        'widget' => [
            'type' => BridgeContentType::WYSIWYG_WIDGET,
            'settings' => [],
            'weight' => $weight++,
            'group' => 'group_block_' . $i
        ],
        'type' => BridgeContentType::WYSIWYG_FIELD,
        'settings' => [
            'cardinality' => 1,
        ],
    ];

    $contentType['fields'][] = [
        'name' => 'block_' . $i . '_content',
        'searchable' => false,
        'translatable' => false,
        'search_result_field' => false,
        'required' => false,
        'weight' => $weight,
        'title' => [
            'en' => 'Read more',
            'fr' => 'En savoir plus',
        ],
        'widget' => [
            'type' => BridgeContentType::SECTION_WIDGET,
            'settings' => [
                'title' => 'Paragraphe',
                'title_plural' => 'Paragraphes',
                'edit_mode' => 'open',
                'add_mode' => 'dropdown',
                'form_display_mode' => 'default',
                'default_paragraph_type' => '',
            ],
            'weight' => $weight++,
            'group' => 'group_block_' . $i
        ],
        'type' => BridgeContentType::SECTION_FIELD,
        'settings' => [
            'target_type' => [
                'accordion',
                'button',
                'call_to_action',
                'files',
                'html',
                'image',
                'map',
                'slider',
                'text',
                'text_with_image',
                'tweet',
                'video',
            ],
            'cardinality' => -1,
        ],
    ];

    $i++;
}

$contentType['groups'][] = [
    'group_name' => 'group_options',
    'entity_type' => 'node',
    'bundle' => 'dashboards',
    'children' => [
        'clients',
        'sites',
        'langcode',
        'created',
        'uid',
    ],
    'weight' => $weight,
    'parent_name' => '',
    'format_settings' => [
        'label' => 'Advanced options',
        'description' => '',
        'required_fields' => true,
        'id' => '',
        'classes' => '',
    ],
    'label' => 'Advanced options',
    'format_type' => 'fieldset',
];

$contentType['fields'][] = [
    'name' => 'clients',
    'searchable' => false,
    'translatable' => false,
    'search_result_field' => false,
    'required' => true,
    'weight' => $weight,
    'title' => [
        'en' => 'Client',
        'fr' => 'Client',
    ],
    'widget' => [
        'type' => BridgeContentType::SELECT_WIDGET,
        'settings' => [],
        'weight' => $weight++,
        'group' => 'group_options'
    ],
    'type' => BridgeContentType::REFERENCE_FIELD,
    'settings' => [
        'target_type' => ['clients'],
        'cardinality' => -1,
    ],
    'selectable_all' => true,
];

$contentType['fields'][] = [
    'name' => 'sites',
    'searchable' => false,
    'translatable' => false,
    'search_result_field' => false,
    'required' => true,
    'weight' => $weight,
    'title' => [
        'en' => 'Cenexi site',
        'fr' => 'Site Cenexi',
    ],
    'widget' => [
        'type' => BridgeContentType::SELECT_WIDGET,
        'settings' => [],
        'weight' => $weight++,
        'group' => 'group_options'
    ],
    'type' => BridgeContentType::REFERENCE_FIELD,
    'settings' => [
        'target_type' => ['sites'],
        'cardinality' => -1,
    ],
    'selectable_all' => true,
];

return $contentType;
