<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'cenexi_notes',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'title' => [
            'en' => 'Notes from Cenexi',
            'fr' => 'Notes from Cenexi',
        ],
    ],
    'fields' => [
        [
            'name' => 'chapo',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'en' => 'Headline',
                'fr' => 'Chapo',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'en' => 'Content',
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'button',
                    'call_to_action',
                    'files',
                    'html',
                    'image',
                    'map',
                    'slider',
                    'text',
                    'text_with_image',
                    'tweet',
                    'video',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'clients',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'en' => 'Client',
                'fr' => 'Client',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['clients'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'sites',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'en' => 'Cenexi site',
                'fr' => 'Site Cenexi',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['sites'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
    ],
];
