<?php

return [
    'build_url_callbacks' => [
        'ecen_ged' => function ($model) {
            $contentType = class_to_type($model);
            $contentUuid = $model->uuid;
            switch ($contentType) {
                case 'shared_documents':
                    $base = $model->langcode === 'en' ? 'shared-documents' : 'documents-partages';
                    $attribute = 'sharedFolders';
                    break;

                case 'space_documents':
                    $base = $model->langcode === 'en' ? 'my-space' : 'mon-espace';
                    $attribute = 'spaceFolders';
                    break;
                default:
                    return null;
            }

            return $base . '?folder=' . $model->{$attribute}->first()->uuid;
        }
    ]
];
