import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesListingPage from '../pages/spaces/SpacesListingPage'

import { fetchSpaces, fetchSpacesListing } from '../fetch/spaces'

import { withFetch } from 'inside-collection/hocs'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          sort: 'weight:asc'
        },
        fields: folderContents.folders.fields
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SpacesListingPage',
    path: '/espaces',
    component: withFetch(SpacesListingPage, { size: 'xxl' })(fetchSpacesListing)
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpaces),
    meta: { content: 'spaces' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'FullWidthPage',
    meta: { disabled: false, content: 'full_width_pages' }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  }
]
