import Microsoft from '@inside-auth/components/login/extra-component/Microsoft'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-auth': {
    extraComponent: {
      is: Microsoft,
      link: `${origin}/saml/login`
    }
  },
  'inside-commons': {
    banner: {
      darkMode: false
    }
  },
  'inside-events': {
    subscriptionEnabled: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-news': {
    newsSuggestionEnabled: true,
    minimalDate: true
  },
  'inside-users': {
    csvImport: true,
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  }
}
