<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Forms;
use Inside\Host\Bridge\BridgeContent;

final class CreateSuggestNewsForm extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $bridge = new BridgeContent();

        $suggestNewsForm = [
            'title' => 'Suggérer de nouvelles actualités',
            'inputs' => '[{"field_choices":[],"field_closed_ended":true,"field_label":null,"field_placeholder":null,"field_description":null,"field_error_message":null,"field_question":"Sélectionnez une catégorie","field_listing_name":"Catégorie","field_slug":"_5alvjsb63","field_order":1,"field_id":"_5alvjsb63","field_type":"input-selectbox","field_required":true,"field_select_type":"content","field_content_type":"news_categories","field_readonly":false,"field_novalidate":false,"field_disabled":false,"field_ghost":false,"field_mail":false,"field_user_can":{"show_in_list_user":true,"show_in_modal_user":true}},{"field_choices":[],"field_label":null,"field_placeholder":null,"field_description":null,"field_error_message":null,"field_question":"Entrez le titre de l\'actualité","field_listing_name":"Titre","field_slug":"_bozdd36qi","field_closed_ended":false,"field_order":2,"field_id":"_bozdd36qi","field_type":"input-text","field_required":true,"field_readonly":false,"field_novalidate":false,"field_disabled":false,"field_ghost":false,"field_mail":false,"field_user_can":{"show_in_list_user":true,"show_in_modal_user":true}},{"field_choices":[],"field_label":null,"field_placeholder":null,"field_description":null,"field_error_message":null,"field_question":"Ajouter un document","field_listing_name":"Document","field_slug":"_07rjxx7mm","field_closed_ended":false,"field_order":4,"field_id":"_07rjxx7mm","field_type":"input-attachment","field_required":false,"field_readonly":false,"field_novalidate":false,"field_disabled":false,"field_ghost":false,"field_mail":false,"field_user_can":{"show_in_list_user":true,"show_in_modal_user":true}},{"field_choices":[],"field_question":"Contenu de l\'article","field_type":"input-textarea","field_listing_name":null,"field_label":null,"field_placeholder":null,"field_description":null,"field_error_message":null,"field_required":true,"field_user_can":{"show_in_list_user":true,"show_in_modal_user":true},"field_readonly":false,"field_novalidate":false,"field_disabled":false,"field_ghost":false,"field_mail":false,"field_slug":"_lklcs34eq","field_closed_ended":false,"field_order":3,"field_id":"_lklcs34eq"},{"field_choices": [],"field_question": "Voir la moyenne des autres répondants","field_type": "input-on-off","field_listing_name": null,"field_label": null,"field_placeholder": null,"field_description": null,"field_error_message": null,"field_required": false,"field_user_can": {"show_in_list_user": true,"show_in_modal_user": true},"field_readonly": false,"field_novalidate": false,"field_disabled": false,"field_ghost": false,"field_mail": false,"field_slug": "_f6b7g5lyc","field_closed_ended": true,"field_order": 5,"field_id": "_f6b7g5lyc"},{"field_choices": [],"field_question": "Ne voir qu\'une seule réponse","field_type": "input-on-off","field_listing_name": null,"field_label": null,"field_placeholder": null,"field_description": null,"field_error_message": null,"field_required": false,"field_user_can": {"show_in_list_user": true,"show_in_modal_user": true},"field_readonly": false,"field_novalidate": false,"field_disabled": false,"field_ghost": false,"field_mail": false,"field_slug": "_ty8hg0hoi","field_closed_ended": true,"field_order": 6,"field_id": "_ty8hg0hoi"},{"field_choices": [],"field_question": "Anonyme","field_type": "input-on-off","field_listing_name": null,"field_label": null,"field_placeholder": null,"field_description": null,"field_error_message": null,"field_required": false,"field_user_can": {"show_in_list_user": true,"show_in_modal_user": true},"field_readonly": false,"field_novalidate": false,"field_disabled": false,"field_ghost": false,"field_mail": false,"field_slug": "_rui7op9jk","field_closed_ended": true,"field_order": 7, "field_id": "_rui7op9jk"},{"field_choices": [],"field_question": "Voir mes réponses","field_type": "input-on-off","field_listing_name": null,"field_label": null,"field_placeholder": null,"field_description": null,"field_error_message": null,"field_required": false,"field_user_can": {"show_in_list_user": true,"show_in_modal_user": true},"field_readonly": false,"field_novalidate": false,"field_disabled": false,"field_ghost": false,"field_mail": false,"field_slug": "_op8jb4yth","field_closed_ended": true,"field_order": 8,"field_id": "_op8jb4yth"},{"field_choices": [],"field_question": "A un statut","field_type": "input-on-off","field_listing_name": null,"field_label": null,"field_placeholder": null,"field_description": null,"field_error_message": null,"field_required": false,"field_user_can": {"show_in_list_user": true,"show_in_modal_user": true},"field_readonly": false,"field_novalidate": false,"field_disabled": false,"field_ghost": false,"field_mail": false,"field_slug": "_ws6dty8ui","field_closed_ended": true,"field_order": 9,"field_id": "_ws6dty8ui"},{"field_choices": [],"field_label": null,"field_placeholder": null,"field_description": null,"field_error_message": null,"field_question": "Aspect admin descendant","field_listing_name": null,"field_slug": "_zfrid8ioy","field_closed_ended": false,"field_order": 10,"field_id": "_zfrid8ioy","field_type": "input-text","field_required": false,"field_readonly": false,"field_novalidate": false,"field_disabled": false,"field_ghost": false,"field_mail": false,"field_user_can": {"show_in_list_user": true,"show_in_modal_user": true}},{"field_choices": [],"field_label": null,"field_placeholder": null,"field_description": null,"field_error_message": null,"field_question": "Aspect utilisateur descendant","field_listing_name": null,"field_slug": "_dsf5to9ez","field_closed_ended": false,"field_order": 11,"field_id": "_dsf5to9ez","field_type": "input-text","field_required": false,"field_readonly": false,"field_novalidate": false,"field_disabled": false,"field_ghost": false,"field_mail": false,"field_user_can": {"show_in_list_user": true,"show_in_modal_user": true}},{"field_choices": [],"field_label": null,"field_placeholder": null,"field_description": null,"field_error_message": null,"field_question": "Rôles des administrateurs","field_listing_name": null,"field_slug": "_aqqz0sjh9ui","field_closed_ended": false,"field_order": 12,"field_id": "_aqqz0sjh9ui","field_type": "input-text","field_required": false,"field_readonly": false,"field_novalidate": false,"field_disabled": false,"field_ghost": false,"field_mail": false,"field_user_can": {"show_in_list_user": true,"show_in_modal_user": true}}]',
            'forms_introduction' => 'Pour nous suggérer une actualité, veuillez remplir le formulaire. Nous étudierons vos suggestions rapidement. Merci de votre contribution.',
            'form_type' => 'forms',
            'show_trends_user' => false,
            'only_one_reply' => false,
            'anonym' => false,
            'show_my_replies' => true,
            'has_status' => true,
            'aside_desc_admin' => null,
            'aside_desc_user' => null,
            'admin_roles' => '[1]', // super_admin
            'status' => true,
        ];

        $existing = Forms::where('title', 'Suggérer de nouvelles actualités')->first();

        if ($existing) {
            $suggestNewsForm['uuid'] = $existing->uuid;
        }

        $bridge->contentInsert('forms', $suggestNewsForm);
    }
}
