<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class SeedDefaultTools extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContent();

        $toolsTitles = collect([
            'Outil 1',
            'Outil 2',
            'Outil 3',
            'Outil 4',
        ]);

        $tools = $toolsTitles->map(function (string $title) use ($bridge) {
            $existing = Tools::where('title', $title)->first();

            if ($existing instanceof Tools) {
                return $existing;
            }

            $uuid = $bridge->contentInsert('tools', ['title' => $title]);

            return Tools::find($uuid);
        });

        $this->getBridge()?->contentTypeCreateOrUpdateField('users', 'tools', [
            'default' => $tools->map(fn (Tools $tool) => ['target_uuid' => $tool->uuid_host])->all(),
        ]);

        $toolsUuids = $tools->map(fn (Tools $tool) => $tool->uuid)->all();
        Users::each(fn (Users $users) => $bridge->contentUpdate('users', ['uuid' => $users->uuid, 'tools' => $toolsUuids]));

        $this->finishUp();
    }
}
