<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class SeedCustoms extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $customs = collect([
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => 'Actualités',
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => 'Événements',
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => 'Annuaire',
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => 'Bibliothèque de ressources',
                'introduction' => 'Retrouvez tous les documents, photos, fiches pratiques…',
            ],
            [
                'custom_slug' => 'spaces',
                'redirection_page' => 'SpacesListingPage',
                'title' => 'Espaces Métiers',
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => 'Vos outils en 1 clic',
            ],
            [
                'title' => 'Mouvements',
                'custom_slug' => 'newcomers',
                'redirection_page' => 'NewcomersListingPage',
            ],
        ]);

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge) {
            $existing = Custom::where('redirection_page', $custom['redirection_page'])->first();

            if ($existing instanceof Custom) {
                $custom['uuid'] = $existing->uuid;
            }

            $bridge->contentInsert('custom', $custom, ! isset($custom['uuid']));
        });
    }
}
