<?php

return [
    'files' => [
        'duva' => [
            'path' => env('XLSX_USERS_PATH', __DIR__.'/../../../../imports/users.xlsx'),
            'fields' => [
                'mail' => 'mail',
                'name' => 'mail',
                'lastname' =>  fn (array $record) => ucwords(trim($record['lastname'] ?? '')),
                'firstname' => fn (array $record) => ucwords(trim($record['firstname'] ?? '')),
                'function' => fn (array $record) => ucwords(trim($record['function'] ?? '')),
                'companies' => fn (array $record) => reference('companies')
                    ->identifiedBy('code')
                    ->from($record['companies'] ?? '')
                    ->get(),
                'locations' => fn (array $record) => reference('locations')
                    ->identifiedBy('code')
                    ->from($record['locations'] ?? '')
                    ->get(),
                'services' => fn (array $record) => reference('services')
                    ->identifiedBy('code')
                    ->from($record['services'] ?? '')
                    ->get(),
                'countries' => fn (array $record) => reference('countries')
                    ->identifiedBy('code')
                    ->from($record['countries'] ?? '')
                    ->get(),
                'phone' => fn (array $record) => $record['phone'] ?? null,
                'status' => fn () => true,
            ],
            'original_fields' => [
                'mail' => 'mail',
                'firstname' => 'firstname',
                'lastname' => 'lastname',
                'function' => 'word',
                'companies' => 'word',
                'locations' => 'city',
                'countries' => 'country',
                'services' => 'word',
                'phone' => 'phone',
            ],
        ],
    ],
];
