<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Route;
use Inside\Routing\Router;

Route::group(
    [
        'namespace'  => 'Inside\DUVA\Http\Controllers',
        'prefix'     => 'api/v1/modals',
        'middleware' => 'auth.api',
    ],
    function (Router $router) {
        $router->get('first_connection', ['uses' => 'ModalsController@firstConnection']);
        $router->get('{modalUuid}/reaction', ['uses' => 'ModalsController@getReaction']);
        $router->post('{modalUuid}/reaction', ['uses' => 'ModalsController@postReaction']);
    }
);
