<?php

use Inside\Content\Models\Contents\Movements;

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => 'newsletter_',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/duva-back/resources/assets/img/logo.png',
        'logoWidth' => 170,
        'showDate' => false,
    ],
    'banner' => [
        'backgroundImageUrl' => 'vendor/maecia/duva-back/resources/assets/newsletter/banner.jpeg',
        'backgroundColor' => '#FFFFF',
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
    ],
    'sections' => [
        'news' => [
            'types' => ['news'],
            'sorts' => ['published_at:desc'],
            'defaultImageUrl' => 'vendor/maecia/duva-back/resources/assets/newsletter/news-default.png',
            'showIntroduction' => true,
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#D69E5B',
            ],
        ],
        'events' => [
            'types' => ['events'],
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#D69E5B',
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionTextColor' => '#D69E5B',
            ],
        ],
        'new_members' => [
            'types' => ['movements'],
            'parentFieldName' => 'folders',
            'leftLineColor' => '#D69E5B',
            'showIntroduction' => true,
            'introductionCallback' => fn (Movements $movement) => $movement->movementsUsers?->first()?->function,
            'link' => [
                'sectionLinkUrl' => 'mouvements',
                'sectionTextColor' => '#D69E5B',
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#D69E5B',
        'links' => [
            'linkedin' => [
                'url' => 'https://fr.linkedin.com/company/groupe-duval',
            ],
            'facebook' => [
                'url' => 'https://www.facebook.com/groupeduval',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/groupe_duval',
            ],
        ],
    ],
    'footer' => [
    ],
];
