<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Content;
use Inside\Host\Migrations\CreateContentTypes;

class AddCodeOnDuvaRef extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();
        collect(['services', 'locations', 'companies', 'countries'])
            ->each(
                function ($contentType) use ($bridgeContent) {
                    $this->migrateContent($contentType, false);
                    Artisan::call('models:rebuild');

                    $contents = type_to_class($contentType)::all();
                    $contents->each(fn ($content) => $bridgeContent->contentUpdate($contentType, [
                        'uuid' => $content->uuid,
                        'code' => str($content->title)->lower()
                    ]));
                }
            );

        collect([
            'countries' => 'Pays',
            'services' => 'Service',
            'locations' => 'Localisation',
            'companies' => 'Entreprise'
        ])->each(fn ($title, $type) => $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: $type,
            options: [
                'name' => $type,
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => $title,
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => [$type],
                    'cardinality' => 1,
                ],
            ],
            weight: 1
        ));

        Artisan::call('models:rebuild');
        $this->finishUp();
    }
}
