<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Content;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class RemoveEntitiesContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridgeContent = new BridgeContent();

        if (! Schema::hasModel('entities')) {
            return;
        }

        $this->bridge->contentTypeDeleteField('user', 'user', 'entities');


        type_to_class('entities')::all()->each(function (Content $entity) use ($bridgeContent) {
            if (is_null($entity->uuid)) {
                return;
            }

            $bridgeContent->contentDelete('entities', $entity->uuid);
        });

        $this->bridge->contentTypeDelete('entities');

        $type = \Drupal::entityTypeManager()->getStorage('node_type')->load('entities');

        if ($type) {
            $type->delete();
        }

        Artisan::call('models:rebuild');
    }
}
