<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddSpacesContentField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'content',
            options: [
                'name' => 'content',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Contenu',
                ],
                'description' => [
                    'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                ],
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraphe',
                        'title_plural' => 'Paragraphes',
                        'edit_mode' => 'open',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '',
                    ],
                ],
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => [
                        'text',
                        'text_two_columns',
                        'text_with_image',
                        'separator',
                        'file',
                        'slider',
                        'image',
                        'video',
                        'map',
                        'accordion',
                        'call_to_action',
                        'button',
                        'html',
                        'tweet',
                        'fetched_contents',
                    ],
                    'cardinality' => -1,
                ],
            ],
            weight: 6
        );
        $this->finishUp();
    }
}
