<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateUsers extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'birthday');

        $this->migrateContent('entities');
        $this->migrateContent('users');
        $this->finishUp();
    }
}
