<?php

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'companies' => fn (mixed $user) => reference('companies')
            ->identifiedBy('code')
            ->from($user->companyName ?? '')
            ->get(),
        'locations' => fn (mixed $user) => reference('locations')
            ->identifiedBy('code')
            ->from($user->city ?? '')
            ->get(),
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from($user->department ?? '')
            ->get(),
        'countries' => fn (mixed $user) => reference('countries')
            ->identifiedBy('code')
            ->from($user->country ?? '')
            ->get(),
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? null,
        'status' => fn () => true,
    ],
    'custom_attributes' => [
    ],
];
