export default {
  'inside-events': {
    showBookmarks: true,
    bookmarkEnabled: true,
    subscriptionEnabled: true,
    subscriptionLinkEnabled: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-jobs': {
    modalName: 'job-offers',
    extraFields: [
      { contracts_types: ['uuid', 'title'] },
      { services: ['uuid', 'title'] },
      { localisations: ['uuid', 'title'] }
    ],
    categoriesFields: [
      {
        contracts_types: {
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        services: {
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        localisations: {
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1 }
        }
      }
    ]
  },
  'inside-layouts': {
    gdprContent: 'popins'
  },
  'inside-users': {
    allowAvatarEdition: false,
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  },
  'inside-workflows': {
    isEnabled: true
  }
}
