<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateGlobalSearchAttributes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        collect([
            'pages',
            'faq_categories',
            'faq_questions'
        ])->each(fn ($contentType) =>  $this->getBridge()?->updateContentTypeOptions(
            type: $contentType,
            options: [
                'global_searchable' => false
            ]
        ));
        $this->getBridge()?->updateContentTypeOptions(
            type: 'tabs_pages',
            options: [
                'searchable' => true,
                'global_searchable' => true
            ]
        );
        $this->call('models:rebuild');
        $this->finishUp();
    }
}
