<?php

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Authentication\Models\User;

return [
    'files' => [
        'dunk' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ';'),
            'fields' => [
                'firstname' => 'surname',
                'lastname' => 'givenname',
                'email' => 'mail',
                'name' => "mail",
                'function' => 'description',
                'phone' => 'telephonenumber',
                'mobile_phone' => 'mobile',
                'image' => function (array $record) {
                    if (! blank($record['image'])) {
                        return $record['image'];
                    }

                    $matricule = $record['matricule'];

                    if (!$matricule) {
                        return '';
                    }

                    $imagePath = 'images/' . str_pad($matricule, 6, '0') . '.jpg';
                    if (!Storage::disk('local')->exists($imagePath)) {
                        return '';
                    }

                    $fileName = Str::uuid() . '.jpg';
                    $chunkId = Str::random(32);
                    $chunkPath = "chunks/$chunkId/$fileName";

                    Storage::makeDirectory("chunks/$chunkId");
                    Storage::disk('local')->copy($imagePath, $chunkPath);

                    return $chunkPath;
                },
                'registration_number' => 'matricule',
                'users' => fn (array $record) => reference('users')
                    ->identifiedBy('registration_number')
                    ->from($record['matricule_responsable'])
                    ->withoutCreation()
                    ->first(),
                'services' => fn (array $record) => reference('services')
                    ->identifiedBy('code')
                    ->from($record['department'])
                    ->get(),
                'localisations' => fn (array $record) => reference('localisations')
                    ->identifiedBy('code')
                    ->from($record['extensionattribute1'])
                    ->get(),
                'status' => fn () => true,
            ],
            'original_fields' => [
                'surname' => 'firstname',
                'givenname' => 'lastname',
                'mail' => 'mail',
                'description' => 'word',
                'telephonenumber' => 'word',
                'mobile' => 'word',
                'image' => 'word',
                'matricule' => 'word',
                'matricule_responsable' => 'word',
                'department' => 'word',
                'extensionattribute1' => 'word',
            ],
        ],
    ],
    'postfilter' => function (Collection $users) {
        $images = User::where('provider_type', 'csv')->with('information')->get()->pluck('information.image', 'email');

        return $users->map(function (array $user) use ($images) {
            $user['image'] = $images->get($user['mail']) ?: null;

            return $user;
        })->toArray();
    }
];
