<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/dunk-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/dunk-back/resources/assets/img/newsletter/bg.png',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'showGreetings' => false,
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'defaultCategoryColor' => '#EA9675',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#EA9675',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#EA9675',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#EA9675'
            ],
        ],
        'job_offers' => [
            'sectionTitleStrKey' => 'newsletter.job_offers_title',
            'introductionLength' => 50,
            'introductionFieldName' => 'content',
            'types' => ['jobs_offers'],
            'fieldLabel' => [
                'movements' => [
                    'fr' => 'Offres d\'emploi',
                ],
            ],
            'link' => [
                'sectionLinkUrl' => 'offres-emploi',
                'sectionTextColor' => '#EA9675',
                'sectionLinkStrKey' => 'newsletter.see_all_job_offers',
            ],
            'modal' => [
                'name' => 'job-offers'
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
