<?php

return [
    'manual_notifications' => [
        'enabled' => true,
        'enabled_types' => [
            'news',
            'events',
            'documents',
            'jobs_offers'
        ],
        'custom_url' => fn (string $channel, string $type, string $id) => match ($type) {
            'jobs_offers' => 'CUSTOM:jobs_offers',
            'documents', 'folders' => 'CUSTOM:ged',
            default => null,
        },
        'enhanced_notifications' => true,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo'
                ],
            ],
            'events' => [
                'fields' => [
                    'image',
                    'chapo'
                ]
            ],
        ]
    ],
    'build_url_callbacks' => [
        'jobs_offers' => fn ($model) => "offres-emploi?modal=job-offers&contentType=$model->content_type&uuid=$model->uuid&size=m",
        'ged' => function ($model) {
            return match ($model->content_type) {
                'folders' => 'bibliotheque?folder=' . $model->uuid,
                'documents' => 'bibliotheque?folder=' . $model->folders->first()->uuid,
                default => data_get($model, 'slug.0'),
            };
        }
    ],
];
