import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'

import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsCategoriesListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsCategoriesPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      filtersInput: 'selectbox',
      authorFields: []
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'FormPage',
    meta: { disabled: true }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/pages/:slug',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'AdminAdvancedSettingsSsoConnectionPage',
    meta: { admin: true, display: true }
  }
]
