import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: async ({ data }) => {
      const { data: spaces } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPage',
        params: {
          slug: spaces?.[0]?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spaces } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: spaces?.[0]?.slug?.[0]
          }
        }
      }
    }
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: [
          'uuid',
          'title',
          'slug',
          { spaces: { fields: ['slug'] } },
          {
            spacesPages: {
              fields: ['uuid'],
              filters: { 'status:eq': 1, sort: 'weight:asc', reverse: true }
            }
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPage',
        params: {
          slug: category?.[0].spaces?.slug?.[0]
        },
        ...(category?.[0]?.spacesPages?.data?.length
          ? { query: { page: category?.[0]?.spacesPages?.data?.[0]?.uuid } }
          : {})
      }
    },
    delete: async ({ uuid }) => {
      const { data: pageCategory } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': uuid }
        }
      )

      return {
        name: 'SpacesPage',
        params: {
          slug: pageCategory?.[0].spaces?.slug?.[0]
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: [
          'status',
          {
            pages_categories: [
              { spaces: { fields: ['uuid', 'title', 'slug'] } }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      const status = spacesPage?.[0]?.status

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPage?.[0].pages_categories?.spaces?.slug?.[0]
        },
        ...(status ? { query: { page: data.uuid } } : {})
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: [
          {
            pages_categories: [
              { spaces: { fields: ['uuid', 'title', 'slug'] } }
            ]
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPage?.[0].pages_categories?.spaces?.slug?.[0]
        }
      }
    }
  }
}
