import { markRaw } from 'vue'
import { IconText } from 'inside-collection/atoms'

export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-jobs': {
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'location',
        tag: markRaw(IconText),
        data: { icon: 'address' },
        value: data?.locations?.title,
        hideIf: () => !data?.locations?.title
      })
    },
    extraFields: [
      { contracts_types: ['uuid', 'title', 'color'] },
      { locations: ['uuid', 'title'] }
    ],
    categoriesFields: [
      {
        locations: {
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        contracts_types: {
          fields: ['uuid', 'title', 'color'],
          filters: { 'status:eq': 1 }
        }
      }
    ]
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true,
    gdprContent: 'popins'
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true,
    authorEnabled: true
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'image',
          'function'
        ]
      }
    }
  }
}
