<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tools',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Outil',
            'en' => 'Tool',
            'nl' => 'Hulpmiddel',
            'pt' => 'Ferramenta',
            'es' => 'Herramienta',
            'de' => 'Werkzeug',
        ],
    ],
    'fields' => [
        [
            'name' => 'tools_categories',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Catégorie d\'outil',
                'en' => 'Tool category',
                'nl' => 'Categorie gereedschap',
                'pt' => 'Categoria de ferramenta',
                'es' => 'Categoría de herramienta',
                'de' => 'Werkzeugkategorie',
            ],
            'description' => [
                'fr' => 'Choix de la catégorie dans laquelle cet outil doit remonter',
                'en' => 'Choice of the category in which this tool should go',
                'nl' => 'Keuze van de categorie waarin deze tool moet vallen',
                'pt' => 'Escolha da categoria em que esta ferramenta deve entrar',
                'es' => 'Elección de la categoría en la que debe ir esta herramienta',
                'de' => 'Auswahl der Kategorie, in die dieses Tool gehören soll',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools_categories'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
                'nl' => 'Icon',
                'pt' => 'Ícone',
                'es' => 'Icono',
                'de' => 'Symbol',
            ],
            'description' => [
                'fr' => 'Définissez une icone pour votre outil, si une image est remplie cette icone ne remontera pas',
                'en' => 'Define an icon for your tool, if an image is filled this icon will not pop up',
                'nl' => 'Definieer een pictogram voor uw tool. Als een afbeelding gevuld is, verschijnt dit pictogram niet',
                'pt' => 'Defina um ícone para sua ferramenta, se uma imagem for preenchida este ícone não aparecerá',
                'es' => 'Defina un ícono para su herramienta; si hay una imagen llena, este ícono no aparecerá',
                'de' => 'Definieren Sie ein Symbol für Ihr Werkzeug. Wenn ein Bild gefüllt ist, wird dieses Symbol nicht angezeigt',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'icon_color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Couleur de l\'icône',
                'en' => 'Icon color',
                'nl' => 'Pictogramkleur',
                'pt' => 'Cor do ícone',
                'es' => 'Color del icono',
                'de' => 'Symbolfarbe',
            ],
            'description' => [
                'fr' => 'Choisissez la couleur de l\'icone a afficher',
                'en' => 'Choose the color of the icon to display',
                'nl' => 'Kies de kleur van het pictogram dat u wilt weergeven',
                'pt' => 'Escolha a cor do ícone a ser exibido',
                'es' => 'Elija el color del icono a mostrar',
                'de' => 'Wählen Sie die Farbe des anzuzeigenden Symbols',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'nl' => 'Afbeelding',
                'pt' => 'Imagem',
                'es' => 'Imagen',
                'de' => 'Bild',
            ],
            'description' => [
                'fr' => 'Cette image remonte comme un logo dans la page outils, les accès rapides ainsi que les pages métiers',
                'en' => 'This image goes up as a logo in the tools page, the quick accesses as well as the business pages',
                'nl' => 'Deze afbeelding verschijnt als een logo op de toolspagina, snelle toegang en op de bedrijfspagina\'s',
                'pt' => 'Esta imagem aparece como um logotipo na página de ferramentas, nos acessos rápidos e nas páginas de negócios',
                'es' => 'Esta imagen sube como logo en la página de herramientas, los accesos rápidos así como en las páginas de negocios',
                'de' => 'Dieses Bild erscheint als Logo auf der Tools-Seite, den Schnellzugriffen sowie den Business-Seiten',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tools_link',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Lien',
                'en' => 'Link',
                'nl' => 'Link',
                'pt' => 'Ligação',
                'es' => 'Enlace',
                'de' => 'Verknüpfung',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'nl' => 'Inhoud',
                'pt' => 'Conteúdo',
                'es' => 'Contenido',
                'de' => 'Inhalt',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up the page',
                'nl' => 'Selecteer de verschillende soorten alinea\'s die u naar boven op de pagina wilt verplaatsen',
                'pt' => 'Seleccione os diferentes tipos de parágrafos que deseja mover para cima da página',
                'es' => 'Seleccione los diferentes tipos de párrafos que desea mover hacia arriba en la página',
                'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'order of appearance',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de exibição',
                'es' => 'orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
                'nl' => 'Het laagste getal gaat naar 1e',
                'pt' => 'O valor mais baixo foi em 1',
                'es' => 'El número más bajo sube en 1er.',
                'de' => 'Die niedrigste Zahl steigt in 1.',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
