<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tabs',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Onglet',
            'en' => 'Tab',
            'nl' => 'Tab',
            'pt' => 'Guia',
            'es' => 'Pestaña',
            'de' => 'Tab',
        ],
    ],
    'fields' => [
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
                'nl' => 'Icon',
                'pt' => 'ícone',
                'es' => 'icono',
                'de' => 'Symbol',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'icon_color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Couleur de l\'icône',
                'en' => 'Icon color',
                'nl' => 'Pictogramkleur',
                'pt' => 'Cor do ícone',
                'es' => 'Color del icono',
                'de' => 'Symbolfarbe',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tabs_spaces',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Espace à onglets',
                'en' => 'Tabbed space',
                'nl' => 'Ruimte met tabbladen',
                'pt' => 'Espaço com guias',
                'es' => 'Espacio con pestañas',
                'de' => 'Leerzeichen mit Tabs',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle l\'onglet doit remonter',
                'en' => 'Choice of space in which the tab should go up',
                'nl' => 'Keuze van de ruimte waarin het lipje omhoog moet',
                'pt' => 'Escolha do espaço em que a aba deve subir',
                'es' => 'Elección del espacio en el que debe subir la pestaña',
                'de' => 'Auswahl des Platzes, in dem die Registerkarte nach oben verschoben werden soll',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tabs_spaces'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de exibição',
                'es' => 'Orden de visualización',
                'de' => 'Reihenfolge anzeigen',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes back to 1st',
                'nl' => 'Het laagste getal gaat naar 1e',
                'pt' => 'O número mais baixo vai para o 1º',
                'es' => 'El número más bajo va al 1.º',
                'de' => 'Die niedrigste Zahl geht an den 1. Platz',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
