<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'events_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Catégorie d\'événement',
            'en' => 'Event category',
            'nl' => 'Categorie evenement',
            'pt' => 'Categoria do evento',
            'es' => 'Categoría de evento',
            'de' => 'Veranstaltungskategorie',
        ],
    ],
    'fields' => [
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'nl' => 'Kleur',
                'pt' => 'Cor',
                'es' => 'Color',
                'de' => 'Farbe',
            ],
            'description' => [
                'fr' => 'Cette couleur sera appliquée sur le nom de la catégorie sur les événements',
                'en' => 'This color will be applied to the category name on events',
                'nl' => 'Deze kleur wordt toegepast op de categorienaam op evenementen',
                'pt' => 'Esta cor será aplicada ao nome da categoria em eventos',
                'es' => 'Este color se aplicará al nombre de la categoría en los eventos.',
                'de' => 'Diese Farbe wird bei Veranstaltungen auf den Kategorienamen angewendet',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
