<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'blocks',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Bloc',
            'en' => 'Bloc',
            'nl' => 'Blok',
            'pt' => 'Bloco',
            'es' => 'Bloc',
            'de' => 'Bloc',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'nl' => 'Afbeelding',
                'pt' => 'Imagem',
                'es' => 'Imagen',
                'de' => 'Bild',
            ],
            'description' => [
                'fr' => 'L\'image remontera sur la gauche du bloc',
                'en' => 'The icon will go up on the left of the block, if an image is completed the icon will not go up',
                'nl' => 'De afbeelding wordt links van het blok verplaatst',
                'pt' => 'O ícone subirá à esquerda do bloco, se uma imagem for completada, o ícone não subirá',
                'es' => 'El icono subirá a la izquierda del bloque, si se completa una imagen el icono no subirá',
                'de' => 'Das Symbol wird auf der linken Seite des Blocks angezeigt, wenn ein Bild fertig ist, wird das Symbol nicht angezeigt',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
                'nl' => 'Icon',
                'pt' => 'Ícone',
                'es' => 'Icono',
                'de' => 'Symbol',
            ],
            'description' => [
                'fr' => 'L\'icone remontera sur la gauche du bloc, si une image est complétée l\'icone ne remontera pas',
                'en' => 'The icon will move up to the left of the block, if an image is completed the icon will not move up',
                'nl' => 'Het pictogram zal links van het blok omhoog bewegen. Als een afbeelding voltooid is, zal het pictogram niet omhoog bewegen',
                'pt' => 'O ícone irá subir para a esquerda do bloco, se uma imagem for completada o ícone não irá subir',
                'es' => 'El ícono se moverá hacia arriba a la izquierda del bloque, si se completa una imagen, el ícono no se moverá hacia arriba',
                'de' => 'Das Symbol bewegt sich links vom Block nach oben. Wenn ein Bild fertig ist, bewegt sich das Symbol nicht nach oben',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'background_color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Couleur de fond',
                'en' => 'Background color',
                'nl' => 'Achtergrondkleur',
                'pt' => 'Cor de fundo',
                'es' => 'Color de fondo',
                'de' => 'Hintergrundfarbe',
            ],
            'description' => [
                'fr' => 'Choix de la couleur de fond du bloc',
                'en' => 'Choice of block background color',
                'nl' => 'Keuze van de achtergrondkleur van het blok',
                'pt' => 'Escolha da cor de fundo do bloco',
                'es' => 'Elección del color de fondo del bloque',
                'de' => 'Auswahl der Blockhintergrundfarbe',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'dark_mode',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Dark mode',
                'en' => 'Dark mode',
                'nl' => 'Donkere modus',
                'pt' => 'Modo escuro',
                'es' => 'Dark mode',
                'de' => 'Dark mode',
            ],
            'description' => [
                'fr' => 'Si le dark mode est activé, le texte et l\'icone seront blancs',
                'en' => 'If the dark mode is activated, the text and the icon will be white',
                'nl' => 'Als de donkere modus is geactiveerd, zijn de tekst en het pictogram wit',
                'pt' => 'Se o modo escuro estiver activado, o texto e o ícone ficarão brancos',
                'es' => 'Si el modo oscuro está activado, el texto y el icono serán de color blanco.',
                'de' => 'Wenn der Dunkelmodus aktiviert ist, sind der Text und das Symbol weiß',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'link',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Lien',
                'en' => 'Link',
                'nl' => 'Link',
                'pt' => 'Ligação',
                'es' => 'Enlace',
                'de' => 'Verknüpfung',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'open_in_new_tab',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Ouvrir dans un nouvel onglet',
                'en' => 'Open in a new tab',
                'nl' => 'Openen in een nieuw tabblad',
                'pt' => 'Abrir em uma nova guia',
                'es' => 'Abrir en una nueva pestaña',
                'de' => 'In einem neuen Tab öffnen',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'link_label',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Texte du lien',
                'en' => 'Link text',
                'nl' => 'Linktekst',
                'pt' => 'Ligar texto',
                'es' => 'Texto del enlace',
                'de' => 'Link Text',
            ],
            'description' => [
                'fr' => 'Si aucun texte n\'est rempli alors le bloc complet sera cliquable',
                'en' => 'If no text is filled then the complete block will be clickable',
                'nl' => 'Als er geen tekst is ingevuld, is het hele blok klikbaar',
                'pt' => 'Se nenhum texto for preenchido, então todo o bloco poderá ser clicado',
                'es' => 'Si no se completa ningún texto, se podrá hacer clic en el bloque completo',
                'de' => 'Wenn kein Text ausgefüllt ist, ist der komplette Block anklickbar',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 6,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'order of appearance',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de exibição',
                'es' => 'orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
                'nl' => 'Het laagste getal gaat naar 1e',
                'pt' => 'O valor mais baixo foi em 1',
                'es' => 'El número más bajo sube en 1er.',
                'de' => 'Die niedrigste Zahl steigt in 1.',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
