<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeUsersFieldsEditable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            'mobile_phone' => [
                'fr' => 'Mobile'
            ],
            'phone' => [
                'fr' => 'Téléphone'
            ],
            'birthday' => [
                'fr' => 'Anniversaire'
            ],
            'function' => [
                'fr' => 'Fonction'
            ]
        ];

        collect($fields)->each(function ($titles, $fieldName) use ($bridge) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $fieldName,
                options: [
                    'title' => $titles,
                    'editable' => true
                ]
            );
        });
    }
}
