<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class FixTranslations extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $authorField = [
            'fr' => 'Auteur',
            'en' => 'Author',
            'es' => 'Autor',
            'nl' => 'Auteur',
            'pt' => 'Autor',
            'de' => 'Autor',
        ];

        $modelsWithAuthorField = InsideSchema::getModelsWithField('authors');

        collect($modelsWithAuthorField)->each(function ($modelWithAuthorField) use ($authorField) {
            InsideSchema::updateFieldOption($modelWithAuthorField, 'authors', 'title', $authorField);
        });

        $contentField = [
            'fr' => 'Contenu',
            'en' => 'Content',
            'es' => 'Contenido',
            'nl' => 'Inhoud',
            'pt' => 'Conteúdo',
            'de' => 'Inhalt',
        ];

        $modelsWithContentField = InsideSchema::getModelsWithField('content');

        collect($modelsWithContentField)->each(function ($modelWithContentField) use ($contentField) {
            InsideSchema::updateFieldOption($modelWithContentField, 'content', 'title', $contentField);
        });
    }
}
