<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
    ],
    'fields' => [
        [
            'name' => 'mobile_phone',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Mobile',
                'en' => 'Mobile phone',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'departments',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Départements',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['departments'],
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'manager',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Manager',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
    ],
];
