export default {
  alerts: {
    add: () => ({
      name: 'HomePage'
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  blocks: {
    add: () => ({
      name: 'HomePage'
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  memorandums: {
    add: ({ data }) => ({
      name: 'MemorandumPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'NewsListingPage'
    })
  },
  careerInfos: {
    add: ({ data }) => ({
      name: 'CareerInfoPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'NewsListingPage'
    })
  },
  contacts: {
    add: () => ({
      name: 'ContactListingPage'
    }),
    delete: () => ({
      name: 'ContactListingPage'
    }),
    globalSearch: ({ data, vm }) => ({
      action: () =>
        vm.triggerModal(
          'contact',
          'fetch',
          { item: data, content: 'contacts' },
          {
            layout: 'right',
            size: 'm',
            transition: 'fadeInLeft',
            closeAll: true
          }
        )
    })
  },
  contactsCategories: {
    extends: 'contacts'
  },
  lhgEvents: {
    add: ({ data }) => ({
      name: 'LiveVideo',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ path: '/' })
  },
  tools: {
    add: () => ({
      name: 'ToolsListingPage'
    }),
    delete: () => ({
      name: 'ToolsListingPage'
    }),
    globalSearch: ({ data, vm }) => ({
      action: () =>
        vm.triggerModal(
          'tool',
          'fetch',
          { item: data, content: 'tools' },
          {
            layout: 'right',
            size: 'm',
            transition: 'fadeInLeft',
            closeAll: true
          }
        )
    })
  },
  toolsCategories: {
    extends: 'tools'
  },
  providers: {
    add: () => ({ name: 'ProvidersDirectoryPage' }),
    delete: () => ({ name: 'ProvidersDirectoryPage' })
  },
  providersCategories: {
    add: () => ({ name: 'ProvidersDirectoryPage' }),
    delete: () => ({ name: 'ProvidersDirectoryPage' })
  }
}
