const newsListing = {
  filters: vm => [
    {
      modelName: 'search',
      type: 'text',
      label: vm.$_tr('customs.news.LISTING.filters.search')
    },
    {
      modelName: 'newsCategories',
      type: 'selectbox',
      fetch: true,
      reference: 'news_categories',
      fields: ['uuid', 'title'],
      filters: { status: 1, sort: 'title:asc' },
      objectLabelKey: 'title',
      objectValueKey: 'uuid',
      label: vm.$_tr('customs.news.LISTING.filters.newsCategories')
    },
    {
      modelName: 'newsTypes',
      type: 'selectbox',
      fetch: true,
      reference: 'news_types',
      fields: ['uuid', 'title'],
      filters: { status: 1, sort: 'title:asc' },
      objectLabelKey: 'title',
      objectValueKey: 'uuid',
      label: vm.$_tr('customs.news.LISTING.filters.newsTypes')
    },
    {
      modelName: 'regionalOfficeTypes',
      type: 'selectbox',
      fetch: true,
      reference: 'regional_office_types',
      fields: ['uuid', 'title'],
      filters: { status: 1, sort: 'title:asc' },
      objectLabelKey: 'title',
      objectValueKey: 'uuid',
      label: vm.$_tr('customs.news.LISTING.filters.regionalOfficeTypes')
    }
  ]
}

export default { newsListing }
