import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import ContactModal from '../components/contact/ContactModal'
import ToolModal from '../components/tool/ToolModal'
import DashboardAddModal from '../components/dashboard/modal/DashboardAddModal'
import AlertModal from '../components/Alert/AlertModal'
import AvatarLegalMentionsModal from '../components/Profile/AvatarLegalMentionsModal'
import MailingStatisticsModal from '../modals/MailingStatisticsModal'
import ProvidersModal from '../components/providers-directory/ProvidersModal'
import TaskModal from '../modals/TaskModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('contact-modal', ContactModal)
    app.component('tool-modal', ToolModal)
    app.component('dashboard-add-modal', DashboardAddModal)
    app.component('alert-modal', AlertModal)
    app.component('avatar-legal-mentions-modal', AvatarLegalMentionsModal)
    app.component('mailing-statistics-modal', MailingStatisticsModal)
    app.component('providers-modal', ProvidersModal)
    app.component('task-modal', TaskModal)
  })
}