import NewsPage from '../pages/news/NewsPage'
import CareerInfoPage from '../pages/career-info/CareerInfoPage'
import MemorandumPage from '../pages/memorandum/MemorandumPage'
import FormPage from '../pages/forms/FormPage'

import LivePage from '../pages/LivePage'

import {
  fetchLive,
  fetchNews,
  fetchCareerInfo,
  fetchMemorandum,
  fetchForm
} from '../fetch'

import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    component: withFetch(NewsPage, { size: 'xxl' })(fetchNews)
  },
  {
    name: 'MemorandumPage',
    path: {
      fr: '/memorandum/:slug',
      en: '/memorandum/:slug'
    },
    component: withFetch(MemorandumPage, { size: 'xxl' })(fetchMemorandum)
  },
  {
    name: 'CareerInfoPage',
    path: {
      fr: '/infos-carriere/:slug',
      en: '/career-infos/:slug'
    },
    component: withFetch(CareerInfoPage, { size: 'xxl' })(fetchCareerInfo)
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false, content: 'events' }
  },
  {
    name: 'ContactListingPage',
    path: {
      fr: '/contacts',
      en: '/contacts'
    },
    component: () => import('../pages/contact/ContactListingPage')
  },
  {
    name: 'ToolsListingPage',
    path: {
      fr: '/outils',
      en: '/tools'
    },
    component: () => import('../pages/tools/ToolsListingPage')
  },
  {
    name: 'DashboardListingPage',
    path: {
      fr: '/tableau-de-bord',
      en: '/dashboard'
    },
    component: () => import('../pages/dashboard/DashboardListingPage')
  },
  {
    name: 'DashboardNewsPage',
    path: {
      fr: '/tableau-de-bord/gestion-des-actualites',
      en: '/dashboard/news-management'
    },
    component: () => import('../components/dashboard/DashboardListing'),
    meta: { content: 'news' }
  },
  {
    name: 'DashboardContactsPage',
    path: {
      fr: '/tableau-de-bord/gestion-des-contacts',
      en: '/dashboard/contacts-management'
    },
    component: () => import('../components/dashboard/DashboardListing'),
    meta: { content: 'contacts' }
  },
  {
    name: 'DashboardToolsPage',
    path: {
      fr: '/tableau-de-bord/gestion-des-outils',
      en: '/dashboard/tools-management'
    },
    component: () => import('../components/dashboard/DashboardListing'),
    meta: { content: 'tools' }
  },
  {
    name: 'DashboardAlertsPage',
    path: {
      fr: '/tableau-de-bord/gestion-des-alertes',
      en: '/dashboard/alerts-management'
    },
    component: () => import('../components/dashboard/DashboardListing'),
    meta: { content: 'alerts' }
  },
  {
    path: '/live/:slug',
    name: 'LiveVideo',
    component: withFetch(LivePage, { size: 'xxl' })(fetchLive),
    meta: { logout: true, content: 'lhg_events' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'ProfilePage',
    component: () => import('../pages/ProfilePage'),
    children: [
      {
        name: 'ProfileShortcuts',
        path: {
          fr: 'acces-rapides',
          en: 'shortcuts'
        },
        component: () =>
          import('@inside-users/components/lib/profile/ProfileShortcuts'),
        props: {
          endpoint: 'desk/tools'
        },
        meta: { tab: 'shortcuts' }
      },
      {
        name: 'ProfileBookmarks',
        path: {
          fr: 'favoris',
          en: 'bookmarks'
        },
        component: () =>
          import('@inside-users/components/lib/profile/ProfileBookmarks'),
        meta: { tab: 'bookmarks' }
      }
    ]
  },
  {
    name: 'AdminMailingStatisticsPage',
    path: {
      fr: '/settings/statistiques-emails',
      en: '/settings/statistics-mailings'
    },
    meta: {
      permissionKey: 'desk_email_statistic',
      _permissionKey: 'desk_email_statistic',
      order: 60
    },
    redirect: { name: 'AdminStatisticsAlertsPage' },
    children: [
      {
        name: 'AdminStatisticsAlertsPage',
        path: {
          fr: 'alertes',
          en: 'alerts'
        },
        component: () => import('../pages/statistics/AdminStatisticsAlertsPage')
      },
      {
        name: 'AdminStatisticsNewslettersPage',
        path: {
          fr: 'newsletters',
          en: 'newsletters'
        },
        component: () =>
          import('../pages/statistics/AdminStatisticsNewslettersPage')
      }
    ]
  },
  {
    name: 'ProvidersDirectoryPage',
    component: () =>
      import('../pages/providers-directory/ProvidersDirectoryPage'),
    path: {
      fr: 'annuaire-des-prestataires',
      en: 'providers-directory'
    }
  },
  {
    name: 'FormPage',
    component: withFetch(FormPage, { size: 'xxl' })(fetchForm)
  },
  {
    name: 'SalesforcePage',
    component: () => import('../pages/salesforce/SalesforcePage'),
    path: {
      fr: 'actions',
      en: 'tasks'
    }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsArtificialIntelligencePage',
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsArtificialIntelligencePage',
    meta: { admin: true, display: true }
  }
]
