export default {
  globals: {
    icons: {
      bookmark: 'rate',
      bookmarkFill: 'rate-fill'
    },
    notificationRedirectionsContentTypes: ['lhg_events'],
    notificationRedirections: {
      lhgEvents: ({ data }) => ({
        name: 'LiveVideo',
        params: { slug: data.slug[0] }
      })
    },
    calendarExportTypes: [
      {
        type: 'google',
        label: 'Google'
      },
      {
        type: 'ics',
        label: 'iCalendar'
      },
      {
        type: 'office',
        label: 'Office'
      },
      {
        type: 'yahoo',
        label: 'Yahoo'
      }
    ]
  },
  'inside-administration': {
    disabledAdvancedSettingsFields: ['ged_enable_likes']
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-commons': {
    banner: {
      imageKey: 'image'
    }
  },
  'inside-layouts': {
    sizeMenuItems: 'l',
    displayBottomLine: false,
    footerFixed: true
  },
  'inside-customs': {
    dashboardContents: ['tools', 'news', 'contacts', 'alerts']
  },
  'inside-edition': {
    translationEnabled: false,
    revisionEnabled: true
  },
  'inside-events': {
    calendarImportEnabled: true,
    icsTypes: [
      {
        type: 'google',
        label: 'Google'
      },
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-forms': {
    surveyDisabledInputs: ['input-on-off'],
    formDisabledInputs: ['input-on-off'],
    submissionEditionEnabled: true,
    showFormAnswerNumber: true,
    extraValidationStatus: [
      {
        key: 'handled',
        value: 3
      }
    ]
  },
  'inside-news': {
    showBookmarks: false
  },
  'inside-users': {
    shortcuts: {
      max: 9
    },
    profil: {
      enabledProfilTabs: [
        { name: 'shortcuts', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'rate' }
      ]
    },
    modalSize: 'l'
  },
  'inside-searches': {
    paginationForMain: 'infiniteScroll'
  },
  'inside-statistics': {
    contentsWithStats: ['career_infos', 'memorandums', 'news']
  },
  'inside-workflows': {
    isEnabled: true
  },
  'inside-wysiwyg': {
    enableIA: true,
    overrides: {
      fontSize: {
        disabled: false
      }
    }
  }
}
