import { http } from '@inside-library/helpers/Http'
import { getStatusFilters } from '@inside-library/helpers/Permissions'

export const fetchLive = async ({ $route }) => {
  try {
    const { data } = await http.get('content/lhg_events', {
      fields: [
        'title',
        'date',
        'last_update',
        'introduction',
        'video_link',
        'admin',
        'uuid',
        'content_type'
      ],
      filters: {
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchNews = async ({ $route }) => {
  try {
    const { data } = await http.get('content/news', {
      fields: [
        'uuid',
        'uuid_host',
        'title',
        'slug',
        'content_type',
        'admin',
        'image',
        'published_at',
        'updated_at',
        'user_has_read',
        'content',
        { users: ['uuid', 'image', 'firstname', 'lastname', 'email'] },
        { comments: ['count'] },
        {
          reactions: [
            'count',
            { users: ['uuid', 'firstname', 'lastname', 'content_type'] }
          ]
        },
        {
          authors: ['uuid', 'firstname', 'lastname', 'image']
        },
        {
          news_categories: {
            fields: ['uuid', 'title', 'content_type', 'slug']
          }
        },
        {
          brands: {
            fields: ['uuid', 'title', 'content_type', 'image']
          }
        },
        {
          management_modes: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'text_color',
              'background_color'
            ]
          }
        },
        {
          countries: {
            fields: ['uuid', 'title', 'content_type']
          }
        },
        {
          profiles: {
            fields: ['uuid', 'title', 'content_type']
          }
        },
        {
          news_types: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'background_color',
              'text_color',
              'class',
              'news_types_icon'
            ]
          }
        },
        {
          regional_office_types: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'background_color',
              'text_color'
            ]
          }
        }
      ],
      filters: {
        'slug:eq': $route.params.slug,
        useStatistics: true
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchCareerInfo = async ({ $route }) => {
  try {
    const { data } = await http.get('content/career_infos', {
      fields: [
        'uuid',
        'uuid_host',
        'published_at',
        'updated_at',
        'hotel_description_text',
        'hotel_environment_text',
        'candidacies_end',
        'contact_info_function',
        'contact_apply_function',
        'admin',
        'missions',
        'missions_title',
        'hotel_name',
        'profile',
        'title',
        'user_has_read',
        'content_type',
        'contact_info_phone',
        'contact_apply_phone',
        'slug',
        'image',
        'hotel_description_image',
        'hotel_environment_image',
        'recruiting_company',
        'profile_title',
        {
          management_modes: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'text_color',
              'background_color'
            ]
          }
        },
        {
          news_categories: ['uuid', 'slug', 'title']
        },
        {
          contact_info_user: ['uuid', 'firstname', 'lastname', 'email']
        },
        {
          contact_apply_user: ['uuid', 'firstname', 'lastname', 'email']
        },
        { brand: ['logo'] },
        {
          reactions: ['count', { users: ['uuid'] }]
        }
      ],
      filters: {
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchMemorandum = async ({ $route }) => {
  try {
    const { data } = await http.get('content/memorandums', {
      fields: [
        'uuid',
        'uuid_host',
        'published_at',
        'updated_at',
        'from',
        'to',
        'cc',
        'content',
        'function',
        'user_has_read',
        'admin',
        'title',
        'content_type',
        'slug',
        {
          management_modes: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'text_color',
              'background_color'
            ]
          }
        },
        {
          news_categories: ['uuid', 'slug', 'title']
        },
        { brand: ['uuid', 'title', 'logo'] },
        {
          contact: ['firstname', 'lastname', 'email']
        },
        {
          reactions: ['count', { users: ['uuid'] }]
        }
      ],
      filters: {
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchForm = async ({ $route }) => {
  try {
    const { data } = await http.get('content/forms', {
      fields: [
        'uuid',
        'uuid_host',
        'title',
        'admin_roles',
        'show_trends_user',
        'admin',
        'content_type',
        'image',
        'forms_introduction',
        'has_status',
        'anonym',
        'only_one_reply',
        'show_my_replies',
        'inputs',
        'form_type',
        'aside_desc_user',
        'aside_desc_admin',
        'published_at',
        'updated_at',
        'user_has_read',
        'slug'
      ],
      filters: {
        ...getStatusFilters('forms'),
        'slug:eq': $route.params.slug,
        'limit:eq': 1
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
